﻿/*//////////////////////////////////////////////////////////////////////////////////////////////////////////

  FIVe3D v2.0  -  2008-04-14
  Flash Interactive Vector-based 3D
  Mathieu Badimon  |  five3d.mathieu-badimon.com  |  www.mathieu-badimon.com  |  contact@mathieu-badimon.com

/*//////////////////////////////////////////////////////////////////////////////////////////////////////////

package org.papervision3d.typography.fonts {
	import org.papervision3d.typography.Font3D;		

	public class HelveticaLight extends Font3D{

		static public var __motifs:Object = {};
		static public var __widths:Object = {};
		static public var __height:Number = 118;
		static public var __initialized:Boolean = false;

		static public function initialize():void {
			initializeMotifsUppercase();
			initializeMotifsLowercase();
			initializeMotifsNumbers();
			initializeMotifsPunctuation();
			initializeWidthsUppercase();
			initializeWidthsLowercase();
			initializeWidthsNumbers();
			initializeWidthsPunctuation();
			__initialized = true;
		}
		
		////////////////////////////////////////////
		override public function get motifs():Object
		{
			if(!__initialized)initialize();
			return __motifs;
		}

		override public function get widths():Object
		{
			if(!__initialized)initialize();
			return __widths;
		}
		
		override public function get height():Number
		{ 
			if(!__initialized)initialize();
			return __height;
		}
		////////////////////////////////////////////

		static private function initializeMotifsUppercase():void {
			__motifs["A"] = [['M',[45.4,68.65]],['L',[17.35,68.65]],['L',[31.65,32.1]],['L',[45.4,68.65]],['M',[28.15,25.3]],['L',[-0.7,96.7]],['L',[6.65,96.7]],['L',[15.25,74.5]],['L',[47.7,74.5]],['L',[56.4,96.7]],['L',[63.7,96.7]],['L',[35.75,25.3]],['L',[28.15,25.3]]];
			__motifs["B"] = [['M',[37.4,62.4]],['C',[46.4,62.4,51.25,65.9]],['C',[56.15,69.35,56.2,76.2]],['C',[56.15,81.85,53.55,85.1]],['C',[51.05,88.35,46.8,89.65]],['C',[42.55,91,37.4,90.9]],['L',[14,90.9]],['L',[14,62.4]],['L',[37.4,62.4]],['M',[53.5,44.5]],['C',[53.5,47.9,51.75,50.65]],['C',[50,53.35,46.45,54.95]],['C',[42.85,56.55,37.4,56.6]],['L',[14,56.6]],['L',[14,31.1]],['L',[37.4,31.1]],['C',[45.35,31.1,49.45,34.5]],['C',[53.5,37.85,53.5,44.5]],['M',[57.05,32.4]],['C',[53.85,28.55,48.7,26.9]],['C',[43.5,25.25,37.4,25.3]],['L',[7.25,25.3]],['L',[7.25,96.7]],['L',[37.4,96.7]],['C',[46.05,96.6,51.15,94.5]],['C',[56.35,92.35,58.9,89.1]],['C',[61.45,85.85,62.25,82.45]],['C',[63.05,79,63,76.4]],['C',[62.9,69.35,58.9,64.65]],['C',[54.9,60.05,47.9,59]],['L',[47.9,58.8]],['C',[51.6,58,54.4,55.65]],['C',[57.2,53.3,58.75,49.9]],['C',[60.25,46.6,60.3,42.8]],['C',[60.2,36.2,57.05,32.4]]];
			__motifs["C"] = [['M',[60.95,34.25]],['C',[56.75,29.1,50.55,26.45]],['C',[44.35,23.8,37.5,23.8]],['C',[29.05,23.85,22.75,26.9]],['C',[16.4,29.9,12.2,35.1]],['C',[8,40.3,5.9,46.95]],['C',[3.8,53.65,3.8,61]],['C',[3.8,68.4,5.9,75.05]],['C',[8,81.7,12.2,86.95]],['C',[16.4,92.1,22.75,95.15]],['C',[29.05,98.15,37.5,98.2]],['C',[45.9,98.15,52.2,94.65]],['C',[58.5,91.15,62.35,84.75]],['C',[66.2,78.3,67.2,69.5]],['L',[60.4,69.5]],['C',[59.7,75.95,56.8,81.1]],['C',[53.9,86.25,49,89.3]],['C',[44.1,92.35,37.5,92.4]],['C',[30.4,92.35,25.3,89.7]],['C',[20.2,87.05,16.95,82.55]],['C',[13.65,78.05,12.15,72.5]],['C',[10.6,66.9,10.6,61]],['C',[10.6,55.1,12.15,49.55]],['C',[13.65,43.95,16.95,39.45]],['C',[20.2,35,25.3,32.3]],['C',[30.4,29.65,37.5,29.6]],['C',[42.7,29.6,47.25,31.65]],['C',[51.75,33.65,55,37.5]],['C',[58.15,41.4,59.4,46.9]],['L',[66.2,46.9]],['C',[65.2,39.4,60.95,34.25]]];
			__motifs["D"] = [['M',[28.5,31.1]],['C',[43.8,30.95,50.9,38.05]],['C',[58,45.15,57.9,61]],['C',[58,76.9,50.9,83.95]],['C',[43.8,91.1,28.5,90.9]],['L',[14,90.9]],['L',[14,31.1]],['L',[28.5,31.1]],['M',[7.25,25.3]],['L',[7.25,96.7]],['L',[31.95,96.7]],['C',[48.05,96.3,56.35,87.4]],['C',[64.65,78.55,64.7,61]],['C',[64.65,43.5,56.35,34.6]],['C',[48.05,25.7,31.95,25.3]],['L',[7.25,25.3]]];
			__motifs["E"] = [['M',[56.5,25.3]],['L',[7.25,25.3]],['L',[7.25,96.7]],['L',[57.05,96.7]],['L',[57.05,90.9]],['L',[14,90.9]],['L',[14,62.7]],['L',[53.8,62.7]],['L',[53.8,56.9]],['L',[14,56.9]],['L',[14,31.1]],['L',[56.5,31.1]],['L',[56.5,25.3]]];
			__motifs["F"] = [['M',[52.5,25.3]],['L',[7.25,25.3]],['L',[7.25,96.7]],['L',[14,96.7]],['L',[14,62.7]],['L',[48.2,62.7]],['L',[48.2,56.9]],['L',[14,56.9]],['L',[14,31.1]],['L',[52.5,31.1]],['L',[52.5,25.3]]];
			__motifs["G"] = [['M',[57.2,39.25]],['C',[60,43.3,60.5,47.5]],['L',[67.3,47.5]],['C',[65.9,39.65,61.75,34.45]],['C',[57.55,29.15,51.3,26.5]],['C',[45.05,23.8,37.5,23.8]],['C',[29.05,23.85,22.75,26.9]],['C',[16.4,29.9,12.2,35.1]],['C',[8,40.3,5.9,46.95]],['C',[3.8,53.6,3.8,60.95]],['C',[3.8,68.4,5.9,75]],['C',[8,81.7,12.2,86.95]],['C',[16.4,92.1,22.75,95.15]],['C',[29.05,98.15,37.5,98.2]],['C',[42.7,98.2,47.4,96.7]],['C',[52.15,95.2,55.95,92]],['C',[59.75,88.8,62.2,83.7]],['L',[62.4,83.7]],['L',[63.3,96.7]],['L',[68.2,96.7]],['L',[68.2,60.35]],['L',[37.9,60.35]],['L',[37.9,66.2]],['L',[62.2,66.2]],['C',[62.3,73.8,59.4,79.7]],['C',[56.55,85.6,51,89]],['C',[45.4,92.35,37.5,92.4]],['C',[30.4,92.35,25.35,89.65]],['C',[20.2,87.05,16.95,82.55]],['C',[13.65,78.05,12.15,72.5]],['C',[10.6,66.9,10.6,60.95]],['C',[10.6,55.05,12.15,49.5]],['C',[13.65,43.9,16.95,39.4]],['C',[20.2,35,25.35,32.3]],['C',[30.4,29.65,37.5,29.6]],['C',[44.35,29.7,49.3,32.45]],['C',[54.3,35.15,57.2,39.25]]];
			__motifs["H"] = [['M',[56.4,25.3]],['L',[56.4,56.25]],['L',[14,56.25]],['L',[14,25.3]],['L',[7.25,25.3]],['L',[7.25,96.7]],['L',[14,96.7]],['L',[14,62.1]],['L',[56.4,62.1]],['L',[56.4,96.7]],['L',[63.2,96.7]],['L',[63.2,25.3]],['L',[56.4,25.3]]];
			__motifs["I"] = [['M',[7.7,25.3]],['L',[7.7,96.7]],['L',[14.5,96.7]],['L',[14.5,25.3]],['L',[7.7,25.3]]];
			__motifs["J"] = [['M',[2.1,73.8]],['C',[1.95,80.1,3.55,85.65]],['C',[5.2,91.2,9.5,94.65]],['C',[13.85,98.1,21.95,98.2]],['C',[29.65,98.2,34.25,95.85]],['C',[38.8,93.55,40.8,88.8]],['C',[42.8,84.05,42.75,76.85]],['L',[42.75,25.3]],['L',[36,25.3]],['L',[36,73.9]],['C',[36.05,80.45,34.85,84.55]],['C',[33.7,88.6,30.75,90.55]],['C',[27.85,92.45,22.6,92.4]],['C',[17.4,92.35,14.5,90.35]],['C',[11.65,88.4,10.5,85.4]],['C',[9.4,82.4,9.15,79.25]],['C',[8.9,76.2,8.9,73.8]],['L',[2.1,73.8]]];
			__motifs["K"] = [['M',[55.5,25.3]],['L',[14,63.7]],['L',[14,25.3]],['L',[7.25,25.3]],['L',[7.25,96.7]],['L',[14,96.7]],['L',[14,72.2]],['L',[27.75,59.5]],['L',[57.4,96.7]],['L',[66.2,96.7]],['L',[32.8,54.8]],['L',[64.7,25.3]],['L',[55.5,25.3]]];
			__motifs["L"] = [['M',[7.25,25.3]],['L',[7.25,96.7]],['L',[54,96.7]],['L',[54,90.9]],['L',[14,90.9]],['L',[14,25.3]],['L',[7.25,25.3]]];
			__motifs["M"] = [['M',[69.5,35.05]],['L',[69.5,96.7]],['L',[76.25,96.7]],['L',[76.25,25.3]],['L',[66.3,25.3]],['L',[41.7,87.9]],['L',[16.95,25.3]],['L',[7,25.3]],['L',[7,96.7]],['L',[13.75,96.7]],['L',[13.75,35.05]],['L',[13.95,35.05]],['L',[38.5,96.7]],['L',[44.85,96.7]],['L',[69.3,35.05]],['L',[69.5,35.05]]];
			__motifs["N"] = [['M',[56.5,25.3]],['L',[56.5,85.7]],['L',[56.3,85.7]],['L',[14.7,25.3]],['L',[7.15,25.3]],['L',[7.15,96.7]],['L',[13.9,96.7]],['L',[13.9,36.3]],['L',[14.1,36.3]],['L',[55.7,96.7]],['L',[63.3,96.7]],['L',[63.3,25.3]],['L',[56.5,25.3]]];
			__motifs["O"] = [['M',[57.55,39.45]],['C',[60.85,43.95,62.35,49.55]],['C',[63.9,55.1,63.9,61]],['C',[63.9,66.9,62.35,72.5]],['C',[60.85,78.05,57.55,82.55]],['C',[54.3,87.05,49.2,89.7]],['C',[44.15,92.35,37.1,92.4]],['C',[30.05,92.35,24.95,89.7]],['C',[19.8,87.05,16.55,82.55]],['C',[13.3,78.05,11.75,72.5]],['C',[10.2,66.9,10.2,61]],['C',[10.2,55.1,11.75,49.55]],['C',[13.3,43.95,16.55,39.45]],['C',[19.8,35,24.95,32.3]],['C',[30.05,29.65,37.1,29.6]],['C',[44.15,29.65,49.2,32.3]],['C',[54.3,35,57.55,39.45]],['M',[62.3,35.1]],['C',[58.1,29.9,51.8,26.9]],['C',[45.5,23.85,37.1,23.8]],['C',[28.65,23.85,22.35,26.9]],['C',[16,29.9,11.8,35.1]],['C',[7.6,40.3,5.5,46.95]],['C',[3.4,53.65,3.4,61]],['C',[3.4,68.4,5.5,75.05]],['C',[7.6,81.7,11.8,86.95]],['C',[16,92.1,22.35,95.15]],['C',[28.65,98.15,37.1,98.2]],['C',[45.5,98.15,51.8,95.15]],['C',[58.1,92.1,62.3,86.95]],['C',[66.5,81.7,68.6,75.05]],['C',[70.7,68.4,70.7,61]],['C',[70.7,53.65,68.6,46.95]],['C',[66.5,40.3,62.3,35.1]]];
			__motifs["P"] = [['M',[53.3,45.65]],['C',[53.2,53.05,48.9,56.65]],['C',[44.6,60.25,37.4,60.25]],['L',[14,60.25]],['L',[14,31.1]],['L',[37.4,31.1]],['C',[44.6,31.1,48.9,34.75]],['C',[53.2,38.35,53.3,45.65]],['M',[57.45,34.7]],['C',[54.85,30.15,50.1,27.75]],['C',[45.35,25.35,38.9,25.3]],['L',[7.25,25.3]],['L',[7.25,96.7]],['L',[14,96.7]],['L',[14,66.1]],['L',[38.9,66.1]],['C',[45.35,66.05,50.1,63.65]],['C',[54.85,61.25,57.45,56.7]],['C',[60.05,52.15,60.1,45.65]],['C',[60.05,39.25,57.45,34.7]]];
			__motifs["Q"] = [['M',[57.55,39.45]],['C',[60.85,43.95,62.35,49.55]],['C',[63.9,55.1,63.9,61]],['C',[63.95,68,61.7,74.4]],['C',[59.5,80.85,54.85,85.4]],['L',[44.45,77.5]],['L',[40.9,81.8]],['L',[50.3,88.9]],['C',[47.6,90.65,44.35,91.5]],['C',[41,92.4,37.1,92.4]],['C',[30.05,92.35,24.95,89.7]],['C',[19.8,87.05,16.55,82.55]],['C',[13.3,78.05,11.75,72.5]],['C',[10.2,66.9,10.2,61]],['C',[10.2,55.1,11.75,49.55]],['C',[13.3,43.95,16.55,39.45]],['C',[19.8,35,24.95,32.3]],['C',[30.05,29.65,37.1,29.6]],['C',[44.15,29.65,49.2,32.3]],['C',[54.3,35,57.55,39.45]],['M',[62.3,35.1]],['C',[58.1,29.9,51.8,26.9]],['C',[45.5,23.85,37.1,23.8]],['C',[28.65,23.85,22.35,26.9]],['C',[16,29.9,11.8,35.1]],['C',[7.6,40.3,5.5,46.95]],['C',[3.4,53.65,3.4,61]],['C',[3.4,68.4,5.5,75]],['C',[7.6,81.7,11.8,86.95]],['C',[16,92.1,22.35,95.15]],['C',[28.65,98.15,37.1,98.2]],['C',[42.7,98.2,47.25,96.85]],['C',[51.9,95.5,55.6,92.9]],['L',[66.7,101.3]],['L',[70.1,97.1]],['L',[59.9,89.3]],['C',[65.35,84,68,76.7]],['C',[70.7,69.35,70.7,61]],['C',[70.7,53.65,68.6,46.95]],['C',[66.5,40.3,62.3,35.1]]];
			__motifs["R"] = [['M',[54.8,45.35]],['C',[54.75,49.7,52.65,52.75]],['C',[50.55,55.9,47.05,57.55]],['C',[43.6,59.2,39.4,59.2]],['L',[14,59.2]],['L',[14,31.1]],['L',[39.4,31.1]],['C',[47.05,31.15,50.95,34.95]],['C',[54.8,38.75,54.8,45.35]],['M',[58.6,33.35]],['C',[55.65,29.2,50.8,27.25]],['C',[45.85,25.3,39.9,25.3]],['L',[7.25,25.3]],['L',[7.25,96.7]],['L',[14,96.7]],['L',[14,65]],['L',[39.8,65]],['C',[46.15,64.85,49.1,67.9]],['C',[52.1,70.9,53,75.7]],['C',[53.9,80.5,54.1,85.6]],['C',[54.2,87.15,54.3,89.2]],['C',[54.45,91.25,54.8,93.25]],['C',[55.2,95.25,56,96.7]],['L',[63.55,96.7]],['C',[62,94.8,61.4,91.45]],['C',[60.75,88.1,60.55,84.55]],['C',[60.3,81,60.2,78.4]],['C',[60,74.15,58.8,70.7]],['C',[57.6,67.3,55,65.1]],['C',[52.3,62.9,47.7,62.35]],['L',[47.7,62.1]],['C',[52.3,61.15,55.35,58.55]],['C',[58.45,56.05,60,52.2]],['C',[61.55,48.45,61.55,43.9]],['C',[61.45,37.45,58.6,33.35]]];
			__motifs["S"] = [['M',[50.1,46]],['L',[56.9,46]],['C',[56.85,38.7,53.2,33.75]],['C',[49.6,28.85,43.6,26.35]],['C',[37.65,23.8,30.5,23.8]],['C',[23,23.9,18.15,25.95]],['C',[13.35,28.05,10.65,31.2]],['C',[8,34.4,6.95,37.8]],['C',[5.85,41.2,5.9,43.9]],['C',[5.95,49.4,8.2,52.85]],['C',[10.45,56.25,14.1,58.15]],['C',[17.7,60.1,21.95,61.1]],['L',[37.9,65]],['C',[41.25,65.8,44.65,67.25]],['C',[48,68.75,50.25,71.3]],['C',[52.5,73.9,52.6,77.9]],['C',[52.55,81.8,50.7,84.55]],['C',[48.9,87.35,45.95,89.05]],['C',[43.05,90.8,39.8,91.6]],['C',[36.55,92.4,33.7,92.4]],['C',[27.1,92.45,21.85,90.7]],['C',[16.5,88.95,13.45,84.75]],['C',[10.3,80.5,10.4,73.2]],['L',[3.6,73.2]],['C',[3.3,81.9,6.9,87.4]],['C',[10.5,92.95,17.05,95.6]],['C',[23.6,98.2,32.1,98.2]],['C',[41.5,98.1,47,95.7]],['C',[52.55,93.35,55.2,89.85]],['C',[57.85,86.4,58.65,83.1]],['C',[59.45,79.75,59.4,77.8]],['C',[59.35,72,56.85,68.35]],['C',[54.35,64.65,50.2,62.45]],['C',[46,60.3,40.85,59]],['L',[23.5,54.7]],['C',[20.55,54,18.1,52.75]],['C',[15.65,51.5,14.2,49.3]],['C',[12.75,47.15,12.7,43.8]],['C',[12.75,38.55,15.3,35.4]],['C',[17.75,32.3,21.85,30.95]],['C',[25.9,29.55,30.6,29.6]],['C',[35.7,29.6,40.05,31.4]],['C',[44.4,33.25,47.1,36.9]],['C',[49.85,40.55,50.1,46]]];
			__motifs["T"] = [['M',[56.1,25.3]],['L',[-0.5,25.3]],['L',[-0.5,31.1]],['L',[24.4,31.1]],['L',[24.4,96.7]],['L',[31.2,96.7]],['L',[31.2,31.1]],['L',[56.1,31.1]],['L',[56.1,25.3]]];
			__motifs["U"] = [['M',[55.2,25.3]],['L',[55.2,69.5]],['C',[55.25,77.75,52.75,82.85]],['C',[50.25,87.85,45.55,90.15]],['C',[40.8,92.45,34.2,92.4]],['C',[27.65,92.45,22.95,90.15]],['C',[18.2,87.85,15.7,82.85]],['C',[13.25,77.75,13.3,69.5]],['L',[13.3,25.3]],['L',[6.5,25.3]],['L',[6.5,71]],['C',[6.45,78.45,9.3,84.6]],['C',[12.1,90.75,18.2,94.4]],['C',[24.3,98.1,34.2,98.2]],['C',[44.15,98.1,50.25,94.4]],['C',[56.4,90.75,59.25,84.6]],['C',[62.05,78.45,62,71]],['L',[62,25.3]],['L',[55.2,25.3]]];
			__motifs["V"] = [['M',[53.05,25.3]],['L',[30.05,89.2]],['L',[29.85,89.2]],['L',[6.65,25.3]],['L',[-0.7,25.3]],['L',[25.85,96.7]],['L',[33.7,96.7]],['L',[60.2,25.3]],['L',[53.05,25.3]]];
			__motifs["W"] = [['M',[83.6,25.3]],['L',[67.3,87.8]],['L',[67.1,87.8]],['L',[49.6,25.3]],['L',[41.1,25.3]],['L',[23.7,87.8]],['L',[23.5,87.8]],['L',[7.3,25.3]],['L',[0,25.3]],['L',[19.8,96.7]],['L',[27.2,96.7]],['L',[45.2,32.85]],['L',[45.4,32.85]],['L',[63.5,96.7]],['L',[70.7,96.7]],['L',[90.4,25.3]],['L',[83.6,25.3]]];
			__motifs["X"] = [['M',[49.4,25.3]],['L',[28.45,55.2]],['L',[8.3,25.3]],['L',[0.3,25.3]],['L',[24.5,59.9]],['L',[-1.2,96.7]],['L',[6.5,96.7]],['L',[28.45,65.2]],['L',[50.2,96.7]],['L',[58.4,96.7]],['L',[32.55,60.15]],['L',[57,25.3]],['L',[49.4,25.3]]];
			__motifs["Y"] = [['M',[54,25.3]],['L',[30.6,61.5]],['L',[7.1,25.3]],['L',[-1,25.3]],['L',[27.1,67.3]],['L',[27.1,96.7]],['L',[33.9,96.7]],['L',[33.9,67.3]],['L',[62.05,25.3]],['L',[54,25.3]]];
			__motifs["Z"] = [['M',[55.1,25.3]],['L',[3.7,25.3]],['L',[3.7,31.1]],['L',[47.5,31.1]],['L',[0.5,90.7]],['L',[0.5,96.7]],['L',[56.1,96.7]],['L',[56.1,90.9]],['L',[8.1,90.9]],['L',[55.1,31.3]],['L',[55.1,25.3]]];
		}

		static private function initializeMotifsLowercase():void {
			__motifs["a"] = [['M',[39,68.5]],['L',[39,76.7]],['C',[39,81.75,36.5,85.35]],['C',[34.1,89,30,90.95]],['C',[25.9,92.9,21,92.9]],['C',[18,92.9,15.45,91.65]],['C',[12.8,90.4,11.2,88.15]],['C',[9.55,85.85,9.5,82.7]],['C',[9.55,79,11.75,76.85]],['C',[13.95,74.75,17.55,73.65]],['C',[21.05,72.65,25.25,72.05]],['C',[29.45,71.45,33.5,70.75]],['C',[34.9,70.6,36.5,70.1]],['C',[38.15,69.6,38.8,68.5]],['L',[39,68.5]],['M',[26.3,43.6]],['C',[20.35,43.6,15.75,45.4]],['C',[11.2,47.2,8.5,51.05]],['C',[5.75,54.85,5.4,60.9]],['L',[11.7,60.9]],['C',[11.95,54.6,15.75,51.75]],['C',[19.55,48.85,25.55,48.9]],['C',[29.25,48.85,32.3,49.75]],['C',[35.35,50.65,37.15,52.95]],['C',[38.95,55.3,39,59.5]],['C',[39,62.3,38.1,63.7]],['C',[37.1,65.1,35.35,65.7]],['C',[33.55,66.25,30.9,66.5]],['C',[25.8,67,20.85,67.75]],['C',[15.95,68.45,11.95,69.95]],['C',[8,71.5,5.65,74.65]],['C',[3.25,77.7,3.2,83.1]],['C',[3.25,88.3,5.6,91.6]],['C',[7.9,95,11.8,96.6]],['C',[15.7,98.2,20.5,98.2]],['C',[25.45,98.2,28.8,97]],['C',[32.25,95.7,34.65,93.4]],['C',[37.15,91.05,39.3,87.7]],['L',[39.5,87.7]],['C',[39.45,90.4,40,92.4]],['C',[40.55,94.45,42.15,95.6]],['C',[43.75,96.65,46.9,96.7]],['C',[48.15,96.7,49.05,96.6]],['C',[50,96.5,51.05,96.3]],['L',[51.05,91]],['C',[50.65,91.15,50.1,91.3]],['C',[49.55,91.4,49,91.4]],['C',[47.1,91.4,46.25,90.4]],['C',[45.3,89.4,45.3,87.55]],['L',[45.3,60.2]],['C',[45.2,53.35,42.45,49.75]],['C',[39.6,46.1,35.3,44.85]],['C',[30.95,43.55,26.3,43.6]]];
			__motifs["b"] = [['M',[14,60.4]],['C',[15.75,55.45,19.8,52.2]],['C',[23.75,49,30.4,48.9]],['C',[36.4,49,40.15,52.2]],['C',[43.85,55.45,45.6,60.4]],['C',[47.3,65.45,47.3,70.85]],['C',[47.3,76.35,45.6,81.35]],['C',[43.85,86.35,40.15,89.55]],['C',[36.4,92.8,30.4,92.9]],['C',[23.75,92.8,19.8,89.55]],['C',[15.75,86.35,14,81.35]],['C',[12.25,76.35,12.3,70.85]],['C',[12.25,65.45,14,60.4]],['M',[22.95,44.9]],['C',[19.4,46.15,16.65,48.65]],['C',[13.9,51.2,12.5,54.9]],['L',[12.3,54.9]],['L',[12.3,25.3]],['L',[6,25.3]],['L',[6,96.7]],['L',[11.8,96.7]],['L',[11.8,86.9]],['L',[12,86.9]],['C',[14.25,92.2,19.2,95.2]],['C',[24.05,98.15,30.4,98.2]],['C',[38.3,98.1,43.4,94.35]],['C',[48.55,90.65,51.05,84.45]],['C',[53.6,78.3,53.6,70.85]],['C',[53.6,63.5,51.05,57.35]],['C',[48.55,51.15,43.4,47.45]],['C',[38.3,43.65,30.4,43.6]],['C',[26.5,43.6,22.95,44.9]]];
			__motifs["c"] = [['M',[27.85,43.6]],['C',[19.9,43.65,14.45,47.4]],['C',[9.05,51.1,6.25,57.25]],['C',[3.4,63.4,3.4,70.85]],['C',[3.4,78.4,6.25,84.55]],['C',[9.05,90.7,14.45,94.4]],['C',[19.9,98.1,27.85,98.2]],['C',[36.5,98.1,42.15,92.85]],['C',[47.75,87.55,49.1,78.2]],['L',[42.8,78.2]],['C',[42.4,82.55,40.3,85.8]],['C',[38.25,89.15,35,91]],['C',[31.75,92.85,27.85,92.9]],['C',[21.8,92.8,17.7,89.6]],['C',[13.7,86.5,11.7,81.45]],['C',[9.7,76.5,9.7,70.85]],['C',[9.7,65.3,11.7,60.3]],['C',[13.7,55.3,17.7,52.15]],['C',[21.8,49,27.85,48.9]],['C',[33.95,48.95,37.55,52.2]],['C',[41.15,55.45,42.45,61.3]],['L',[48.75,61.3]],['C',[47.95,55.4,45.1,51.45]],['C',[42.3,47.55,37.8,45.55]],['C',[33.35,43.6,27.85,43.6]]];
			__motifs["d"] = [['M',[11.8,60.4]],['C',[13.55,55.45,17.3,52.2]],['C',[21.05,49,27,48.9]],['C',[33.7,49,37.65,52.2]],['C',[41.65,55.45,43.4,60.4]],['C',[45.15,65.45,45.1,70.85]],['C',[45.15,76.35,43.4,81.35]],['C',[41.65,86.35,37.65,89.55]],['C',[33.7,92.8,27,92.9]],['C',[21.05,92.8,17.3,89.55]],['C',[13.55,86.35,11.8,81.35]],['C',[10.1,76.35,10.1,70.85]],['C',[10.1,65.45,11.8,60.4]],['M',[45.1,25.3]],['L',[45.1,54.9]],['L',[44.9,54.9]],['C',[43.5,51.2,40.75,48.65]],['C',[38.05,46.15,34.45,44.9]],['C',[30.9,43.6,27,43.6]],['C',[19.2,43.65,14,47.45]],['C',[8.9,51.15,6.35,57.35]],['C',[3.8,63.5,3.8,70.85]],['C',[3.8,78.3,6.35,84.45]],['C',[8.9,90.65,14,94.35]],['C',[19.2,98.1,27,98.2]],['C',[30.8,98.15,34.5,96.75]],['C',[38.25,95.35,41.1,92.8]],['C',[44,90.25,45.4,86.9]],['L',[45.6,86.9]],['L',[45.6,96.7]],['L',[51.4,96.7]],['L',[51.4,25.3]],['L',[45.1,25.3]]];
			__motifs["e"] = [['M',[17.95,51.6]],['C',[21.6,48.95,26.7,48.9]],['C',[31.85,48.95,35.45,51.55]],['C',[39.05,54.1,41,58.3]],['C',[42.95,62.45,43.1,67.3]],['L',[9.7,67.3]],['C',[10.2,62.5,12.25,58.35]],['C',[14.35,54.15,17.95,51.6]],['M',[26.7,43.6]],['C',[20.55,43.6,16.15,45.9]],['C',[11.7,48.25,8.95,52.1]],['C',[6.1,56.05,4.75,60.9]],['C',[3.4,65.75,3.4,70.9]],['C',[3.4,78.35,5.8,84.55]],['C',[8.25,90.7,13.4,94.4]],['C',[18.55,98.1,26.7,98.2]],['C',[36.45,98.15,41.85,93.35]],['C',[47.25,88.55,49.2,79.7]],['L',[42.9,79.7]],['C',[41.45,85.65,37.5,89.25]],['C',[33.6,92.8,26.7,92.9]],['C',[20.7,92.8,16.95,89.65]],['C',[13.25,86.6,11.45,81.95]],['C',[9.7,77.3,9.7,72.65]],['L',[49.4,72.65]],['C',[49.6,67.1,48.4,61.95]],['C',[47.2,56.8,44.5,52.65]],['C',[41.75,48.5,37.35,46.05]],['C',[32.9,43.6,26.7,43.6]]];
			__motifs["f"] = [['M',[0.65,45.1]],['L',[0.65,50.4]],['L',[9.4,50.4]],['L',[9.4,96.7]],['L',[15.7,96.7]],['L',[15.7,50.4]],['L',[25.95,50.4]],['L',[25.95,45.1]],['L',[15.7,45.1]],['L',[15.7,40.6]],['C',[15.7,37.75,16,35.5]],['C',[16.3,33.25,17.7,31.95]],['C',[19.2,30.65,22.6,30.65]],['C',[23.75,30.65,24.85,30.8]],['C',[26,30.9,27.2,31.1]],['L',[27.2,25.7]],['C',[25.75,25.5,24.5,25.4]],['C',[23.25,25.3,21.9,25.3]],['C',[16.9,25.35,14.15,27.25]],['C',[11.45,29.15,10.4,32.55]],['C',[9.35,35.95,9.4,40.4]],['L',[9.4,45.1]],['L',[0.65,45.1]]];
			__motifs["g"] = [['M',[11.45,60]],['C',[13.25,55.15,17,52.05]],['C',[20.75,49,26.7,48.9]],['C',[32.6,49,36.35,52.2]],['C',[40,55.4,41.65,60.25]],['C',[43.35,65.1,43.3,70.3]],['C',[43.3,75.65,41.45,80.3]],['C',[39.55,84.95,35.85,87.8]],['C',[32.2,90.7,26.7,90.8]],['C',[20.9,90.7,17.15,87.8]],['C',[13.4,84.9,11.5,80.25]],['C',[9.7,75.6,9.7,70.3]],['C',[9.7,64.85,11.45,60]],['M',[43.3,45.1]],['L',[43.3,54]],['L',[43.1,54]],['C',[41.15,49.6,36.75,46.65]],['C',[32.4,43.7,26.7,43.6]],['C',[19.25,43.65,14.05,47.2]],['C',[8.85,50.65,6.15,56.5]],['C',[3.4,62.4,3.4,69.6]],['C',[3.4,77,5.8,83]],['C',[8.2,89,13.35,92.5]],['C',[18.5,96,26.7,96.1]],['C',[32.3,96,36.6,93.2]],['C',[40.85,90.3,43.1,85.5]],['L',[43.3,85.5]],['L',[43.3,92.5]],['C',[43.35,101.95,39.35,106.95]],['C',[35.35,111.95,26.7,112]],['C',[23.15,112.05,20,111]],['C',[16.85,110.05,14.6,107.75]],['C',[12.35,105.5,11.6,101.7]],['L',[5.3,101.7]],['C',[5.85,107.2,9,110.6]],['C',[12.1,114.1,16.8,115.7]],['C',[21.5,117.3,26.7,117.3]],['C',[35.1,117.25,40.15,114.3]],['C',[45.15,111.3,47.35,105.8]],['C',[49.6,100.2,49.6,92.5]],['L',[49.6,45.1]],['L',[43.3,45.1]]];
			__motifs["h"] = [['M',[28.9,43.6]],['C',[25.2,43.6,21.9,44.9]],['C',[18.55,46.2,16.05,48.55]],['C',[13.55,50.85,12.4,54]],['L',[12.2,54]],['L',[12.2,25.3]],['L',[5.9,25.3]],['L',[5.9,96.7]],['L',[12.2,96.7]],['L',[12.2,66.55]],['C',[12.3,61.5,14.25,57.5]],['C',[16.2,53.55,19.8,51.25]],['C',[23.4,48.95,28.4,48.9]],['C',[33.45,48.95,36.35,50.95]],['C',[39.2,53,40.4,56.5]],['C',[41.55,60,41.5,64.45]],['L',[41.5,96.7]],['L',[47.8,96.7]],['L',[47.8,63.5]],['C',[47.85,57.3,46.15,52.85]],['C',[44.4,48.4,40.25,46]],['C',[36.1,43.6,28.9,43.6]]];
			__motifs["i"] = [['M',[12.4,35.4]],['L',[12.4,25.3]],['L',[6.1,25.3]],['L',[6.1,35.4]],['L',[12.4,35.4]],['M',[6.1,45.1]],['L',[6.1,96.7]],['L',[12.4,96.7]],['L',[12.4,45.1]],['L',[6.1,45.1]]];
			__motifs["j"] = [['M',[12.4,35.4]],['L',[12.4,25.3]],['L',[6.1,25.3]],['L',[6.1,35.4]],['L',[12.4,35.4]],['M',[6.1,45.1]],['L',[6.1,103]],['C',[6.2,106.25,5.1,108.3]],['C',[3.95,110.4,0.4,110.45]],['C',[-0.4,110.55,-1.25,110.5]],['C',[-2.2,110.45,-3,110.35]],['L',[-3,115.6]],['C',[-1.85,115.6,-0.8,115.7]],['C',[0.3,115.8,1.4,115.8]],['C',[5.8,115.75,8.2,113.8]],['C',[10.6,111.85,11.5,108.6]],['C',[12.45,105.4,12.4,101.5]],['L',[12.4,45.1]],['L',[6.1,45.1]]];
			__motifs["k"] = [['M',[40.9,45.1]],['L',[12.3,70.15]],['L',[12.3,25.3]],['L',[6,25.3]],['L',[6,96.7]],['L',[12.3,96.7]],['L',[12.3,77.05]],['L',[22.5,68.6]],['L',[42.9,96.7]],['L',[50.8,96.7]],['L',[27.3,64.2]],['L',[49.3,45.1]],['L',[40.9,45.1]]];
			__motifs["l"] = [['M',[6.1,25.3]],['L',[6.1,96.7]],['L',[12.4,96.7]],['L',[12.4,25.3]],['L',[6.1,25.3]]];
			__motifs["m"] = [['M',[60.25,43.6]],['C',[55.05,43.6,50.65,46.05]],['C',[46.25,48.6,43.8,53.7]],['C',[42.3,48.6,38.3,46.05]],['C',[34.25,43.6,29,43.6]],['C',[22.9,43.6,18.7,46.35]],['C',[14.55,49.1,12.1,53.8]],['L',[11.8,53.8]],['L',[11.8,45.1]],['L',[6,45.1]],['L',[6,96.7]],['L',[12.3,96.7]],['L',[12.3,67.9]],['C',[12.35,62.4,13.9,58.15]],['C',[15.55,53.9,18.9,51.45]],['C',[22.25,48.95,27.75,48.9]],['C',[31.7,48.95,34.1,50.65]],['C',[36.5,52.35,37.55,55.25]],['C',[38.55,58.15,38.55,61.7]],['L',[38.55,96.7]],['L',[44.8,96.7]],['L',[44.8,67.5]],['C',[44.8,62.6,46.05,58.4]],['C',[47.25,54.15,50.35,51.6]],['C',[53.4,48.95,58.85,48.9]],['C',[65.55,48.9,68.3,52.25]],['C',[71.15,55.6,71.05,62]],['L',[71.05,96.7]],['L',[77.35,96.7]],['L',[77.35,61.7]],['C',[77.35,52.55,73.05,48.05]],['C',[68.75,43.6,60.25,43.6]]];
			__motifs["n"] = [['M',[28.9,43.6]],['C',[25.2,43.6,21.9,44.9]],['C',[18.55,46.2,16.05,48.55]],['C',[13.55,50.85,12.4,54]],['L',[12.2,54]],['L',[12.2,45.1]],['L',[5.9,45.1]],['L',[5.9,96.7]],['L',[12.2,96.7]],['L',[12.2,66.55]],['C',[12.3,61.5,14.25,57.5]],['C',[16.2,53.55,19.8,51.25]],['C',[23.4,48.95,28.4,48.9]],['C',[33.45,48.95,36.35,50.95]],['C',[39.2,53,40.4,56.5]],['C',[41.55,60,41.5,64.45]],['L',[41.5,96.7]],['L',[47.8,96.7]],['L',[47.8,63.5]],['C',[47.85,57.3,46.15,52.85]],['C',[44.4,48.4,40.25,46]],['C',[36.1,43.6,28.9,43.6]]];
			__motifs["o"] = [['M',[17.7,52.15]],['C',[21.8,49,27.85,48.9]],['C',[33.85,49,37.9,52.15]],['C',[41.9,55.3,43.9,60.3]],['C',[45.9,65.3,45.9,70.85]],['C',[45.9,76.5,43.9,81.45]],['C',[41.9,86.5,37.9,89.6]],['C',[33.85,92.8,27.85,92.9]],['C',[21.8,92.8,17.7,89.6]],['C',[13.7,86.5,11.7,81.45]],['C',[9.7,76.5,9.7,70.85]],['C',[9.7,65.3,11.7,60.3]],['C',[13.7,55.3,17.7,52.15]],['M',[14.45,47.4]],['C',[9.05,51.1,6.25,57.25]],['C',[3.4,63.4,3.4,70.85]],['C',[3.4,78.4,6.25,84.55]],['C',[9.05,90.7,14.45,94.4]],['C',[19.9,98.1,27.85,98.2]],['C',[35.75,98.1,41.15,94.4]],['C',[46.6,90.7,49.35,84.55]],['C',[52.2,78.4,52.2,70.85]],['C',[52.2,63.4,49.35,57.25]],['C',[46.6,51.1,41.15,47.4]],['C',[35.75,43.65,27.85,43.6]],['C',[19.9,43.65,14.45,47.4]]];
			__motifs["p"] = [['M',[13.9,60]],['C',[15.6,55,19.55,51.95]],['C',[23.5,49,30.4,48.9]],['C',[36.4,49,40.15,52.2]],['C',[43.85,55.45,45.6,60.4]],['C',[47.3,65.45,47.3,70.85]],['C',[47.3,76.35,45.6,81.35]],['C',[43.85,86.35,40.15,89.55]],['C',[36.4,92.8,30.4,92.9]],['C',[23.75,92.8,19.8,89.55]],['C',[15.75,86.35,14,81.35]],['C',[12.25,76.35,12.3,70.85]],['C',[12.25,64.95,13.9,60]],['M',[19.2,46.6]],['C',[14.25,49.6,12,54.9]],['L',[11.8,54.9]],['L',[11.8,45.1]],['L',[6,45.1]],['L',[6,115.8]],['L',[12.3,115.8]],['L',[12.3,86.9]],['L',[12.5,86.9]],['C',[13.9,90.6,16.65,93.15]],['C',[19.4,95.65,22.95,96.9]],['C',[26.5,98.2,30.4,98.2]],['C',[38.3,98.1,43.4,94.35]],['C',[48.55,90.65,51.05,84.45]],['C',[53.6,78.3,53.6,70.85]],['C',[53.6,63.5,51.05,57.35]],['C',[48.55,51.15,43.4,47.45]],['C',[38.3,43.65,30.4,43.6]],['C',[24.05,43.6,19.2,46.6]]];
			__motifs["q"] = [['M',[11.8,60.4]],['C',[13.55,55.45,17.3,52.2]],['C',[21.05,49,27,48.9]],['C',[33.7,49,37.65,52.2]],['C',[41.65,55.45,43.4,60.4]],['C',[45.15,65.45,45.1,70.85]],['C',[45.15,76.35,43.4,81.35]],['C',[41.65,86.35,37.65,89.55]],['C',[33.7,92.8,27,92.9]],['C',[21.05,92.8,17.3,89.55]],['C',[13.55,86.35,11.8,81.35]],['C',[10.1,76.35,10.1,70.85]],['C',[10.1,65.45,11.8,60.4]],['M',[45.6,45.1]],['L',[45.6,54.9]],['L',[45.4,54.9]],['C',[44,51.55,41.1,49]],['C',[38.25,46.45,34.5,45.05]],['C',[30.8,43.6,27,43.6]],['C',[19.2,43.65,14,47.45]],['C',[8.9,51.15,6.35,57.35]],['C',[3.8,63.5,3.8,70.85]],['C',[3.8,78.3,6.35,84.45]],['C',[8.9,90.65,14,94.35]],['C',[19.2,98.1,27,98.2]],['C',[30.9,98.2,34.45,96.9]],['C',[38.05,95.65,40.75,93.15]],['C',[43.5,90.6,44.9,86.9]],['L',[45.1,86.9]],['L',[45.1,115.8]],['L',[51.4,115.8]],['L',[51.4,45.1]],['L',[45.6,45.1]]];
			__motifs["r"] = [['M',[19.5,47.5]],['C',[14.45,50.85,12,57.15]],['L',[11.8,57.15]],['L',[11.8,45.1]],['L',[6,45.1]],['L',[6,96.7]],['L',[12.3,96.7]],['L',[12.3,69.2]],['C',[12.35,63.75,14.75,59.5]],['C',[17.15,55.2,21.45,52.8]],['C',[25.8,50.4,31.5,50.65]],['L',[31.5,44.35]],['C',[24.45,44.1,19.5,47.5]]];
			__motifs["s"] = [['M',[24.3,43.6]],['C',[19.65,43.6,15.25,45]],['C',[10.8,46.45,7.9,49.7]],['C',[5,52.85,4.9,58.1]],['C',[4.95,62.4,6.8,65.1]],['C',[8.65,67.75,11.9,69.3]],['C',[15.15,70.8,19.3,71.9]],['L',[27.4,73.7]],['C',[30.3,74.4,32.85,75.4]],['C',[35.45,76.5,37.05,78.3]],['C',[38.65,80.15,38.7,83.1]],['C',[38.6,86.7,36.4,88.85]],['C',[34.15,91,30.9,91.95]],['C',[27.7,92.95,24.6,92.9]],['C',[18.2,92.9,14.05,89.6]],['C',[9.9,86.4,9.4,80]],['L',[3.15,80]],['C',[4,89.4,9.6,93.8]],['C',[15.25,98.25,24.3,98.2]],['C',[29.25,98.2,33.95,96.65]],['C',[38.65,95.15,41.8,91.7]],['C',[44.9,88.25,45,82.7]],['C',[44.9,78.2,42.8,75.2]],['C',[40.65,72.25,37.35,70.6]],['C',[34,68.9,30.3,68.4]],['L',[21.9,66.5]],['C',[19.7,66,17.2,65]],['C',[14.75,64.05,13,62.3]],['C',[11.3,60.55,11.2,57.8]],['C',[11.25,54.45,13.1,52.5]],['C',[14.95,50.55,17.7,49.75]],['C',[20.5,48.85,23.4,48.9]],['C',[27.05,48.9,30.05,50.05]],['C',[33.05,51.3,34.85,53.8]],['C',[36.7,56.3,36.9,60.2]],['L',[43.2,60.2]],['C',[42.95,54.6,40.45,50.9]],['C',[37.9,47.25,33.7,45.4]],['C',[29.5,43.6,24.3,43.6]]];
			__motifs["t"] = [['M',[9.7,29.6]],['L',[9.7,45.1]],['L',[0.75,45.1]],['L',[0.75,50.4]],['L',[9.7,50.4]],['L',[9.7,85.65]],['C',[9.55,92.15,12.1,94.8]],['C',[14.7,97.4,20.9,97.3]],['C',[22.3,97.3,23.75,97.2]],['C',[25.1,97.1,26.5,97.1]],['L',[26.5,91.65]],['C',[23.85,91.95,21.1,91.95]],['C',[17.8,91.7,16.9,90]],['C',[15.9,88.25,16,85.2]],['L',[16,50.4]],['L',[26.5,50.4]],['L',[26.5,45.1]],['L',[16,45.1]],['L',[16,29.6]],['L',[9.7,29.6]]];
			__motifs["u"] = [['M',[41.5,45.1]],['L',[41.5,72.2]],['C',[41.5,77.55,39.9,82.25]],['C',[38.25,86.95,34.8,89.85]],['C',[31.4,92.8,26.05,92.9]],['C',[18.6,92.9,15.5,89.3]],['C',[12.3,85.65,12.2,78.7]],['L',[12.2,45.1]],['L',[5.9,45.1]],['L',[5.9,78.6]],['C',[5.8,87.7,10.1,92.9]],['C',[14.35,98.1,24,98.2]],['C',[29.9,98.15,34.55,95.4]],['C',[39.25,92.6,41.8,87.35]],['L',[42,87.35]],['L',[42,96.7]],['L',[47.8,96.7]],['L',[47.8,45.1]],['L',[41.5,45.1]]];
			__motifs["v"] = [['M',[0.2,45.1]],['L',[20.1,96.7]],['L',[26.8,96.7]],['L',[46.1,45.1]],['L',[39.6,45.1]],['L',[23.6,90.4]],['L',[23.4,90.4]],['L',[7.2,45.1]],['L',[0.2,45.1]]];
			__motifs["w"] = [['M',[66.6,45.1]],['L',[53.35,89.3]],['L',[53.15,89.3]],['L',[40.6,45.1]],['L',[33.5,45.1]],['L',[20.9,89.3]],['L',[20.7,89.3]],['L',[7.5,45.1]],['L',[0.8,45.1]],['L',[17.4,96.7]],['L',[24.25,96.7]],['L',[36.85,53.3]],['L',[37.1,53.3]],['L',[49.8,96.7]],['L',[56.7,96.7]],['L',[73.3,45.1]],['L',[66.6,45.1]]];
			__motifs["x"] = [['M',[1.6,45.1]],['L',[20.1,69.9]],['L',[0.1,96.7]],['L',[7.9,96.7]],['L',[23.8,74.95]],['L',[40,96.7]],['L',[48,96.7]],['L',[27.9,69.8]],['L',[46.5,45.1]],['L',[38.55,45.1]],['L',[24.2,64.65]],['L',[9.5,45.1]],['L',[1.6,45.1]]];
			__motifs["y"] = [['M',[0.2,45.1]],['L',[20.8,96.5]],['L',[18.6,102.35]],['C',[17.6,104.8,16.55,106.6]],['C',[15.6,108.4,13.95,109.45]],['C',[12.35,110.45,9.6,110.45]],['C',[8.55,110.45,7.45,110.3]],['C',[6.4,110.25,5.25,110]],['L',[5.25,115.3]],['C',[6,115.55,7.15,115.65]],['C',[8.25,115.75,10.1,115.8]],['C',[13.95,115.85,16.3,114.8]],['C',[18.7,113.8,20.3,111.35]],['C',[21.95,108.9,23.7,104.55]],['L',[46.1,45.1]],['L',[39.8,45.1]],['L',[23.9,89.1]],['L',[6.9,45.1]],['L',[0.2,45.1]]];
			__motifs["z"] = [['M',[35.2,50.4]],['L',[1.5,91.55]],['L',[1.5,96.7]],['L',[44.6,96.7]],['L',[44.6,91.4]],['L',[9.1,91.4]],['L',[43.2,49.6]],['L',[43.2,45.1]],['L',[3.8,45.1]],['L',[3.8,50.4]],['L',[35.2,50.4]]];
		}

		static private function initializeMotifsNumbers():void {
			__motifs["0"] = [['M',[37.4,34.5]],['C',[41,37.5,42.85,42.2]],['C',[44.7,46.95,45.3,52.2]],['C',[45.95,57.5,45.9,62.1]],['C',[45.95,66.75,45.3,72.05]],['C',[44.7,77.35,42.85,82.05]],['C',[41,86.8,37.4,89.8]],['C',[33.75,92.8,27.85,92.9]],['C',[21.9,92.8,18.2,89.8]],['C',[14.6,86.8,12.75,82.05]],['C',[10.95,77.35,10.3,72.05]],['C',[9.65,66.75,9.7,62.1]],['C',[9.65,57.5,10.3,52.2]],['C',[10.95,46.95,12.75,42.2]],['C',[14.6,37.5,18.2,34.5]],['C',[21.9,31.5,27.85,31.4]],['C',[33.75,31.5,37.4,34.5]],['M',[15.4,29.4]],['C',[10.6,32.7,7.95,38]],['C',[5.35,43.35,4.35,49.65]],['C',[3.35,56,3.4,62.25]],['C',[3.35,68.45,4.35,74.75]],['C',[5.35,81.05,7.95,86.3]],['C',[10.6,91.6,15.4,94.9]],['C',[20.2,98.1,27.85,98.2]],['C',[35.4,98.1,40.25,94.9]],['C',[45,91.6,47.65,86.3]],['C',[50.25,81,51.25,74.7]],['C',[52.25,68.35,52.2,62.1]],['C',[52.25,55.9,51.25,49.6]],['C',[50.25,43.3,47.65,38]],['C',[45,32.7,40.25,29.4]],['C',[35.4,26.2,27.85,26.1]],['C',[20.2,26.2,15.4,29.4]]];
			__motifs["1"] = [['M',[28.2,44.7]],['L',[28.2,96.7]],['L',[34.5,96.7]],['L',[34.5,26.7]],['L',[29.45,26.7]],['C',[28.45,33.05,25.95,35.85]],['C',[23.4,38.65,19.3,39.4]],['C',[15.25,40.1,9.7,40.2]],['L',[9.7,44.7]],['L',[28.2,44.7]]];
			__motifs["2"] = [['M',[46.5,34.95]],['C',[43.65,30.55,38.75,28.35]],['C',[33.9,26.1,27.75,26.1]],['C',[20.1,26.15,15.1,29.3]],['C',[10.05,32.5,7.6,38.05]],['C',[5.2,43.6,5.3,50.9]],['L',[11.6,50.9]],['C',[11.45,45.65,13.1,41.3]],['C',[14.65,36.9,18.15,34.15]],['C',[21.7,31.45,27.45,31.4]],['C',[31.75,31.4,35.25,33.1]],['C',[38.8,34.8,40.9,37.95]],['C',[43.05,41.15,43.1,45.7]],['C',[43.1,49.85,41.65,52.95]],['C',[40.2,56.05,37.3,58.9]],['C',[32.7,63.25,27.1,66.9]],['C',[21.5,70.55,16.2,74.5]],['C',[10.95,78.4,7.4,83.7]],['C',[3.95,89,3.6,96.7]],['L',[49.7,96.7]],['L',[49.7,90.9]],['L',[10.85,90.9]],['C',[11.5,87.35,13.85,84.45]],['C',[16.2,81.45,19.4,79]],['C',[22.6,76.55,25.95,74.5]],['C',[29.2,72.45,31.85,70.7]],['C',[36.45,67.8,40.45,64.25]],['C',[44.4,60.65,46.9,56.1]],['C',[49.3,51.65,49.4,45.8]],['C',[49.35,39.35,46.5,34.95]]];
			__motifs["3"] = [['M',[45.5,33.75]],['C',[42.45,29.85,37.5,27.95]],['C',[32.55,26.1,27,26.1]],['C',[20.15,26.15,15.25,29.1]],['C',[10.3,32.1,7.6,37.3]],['C',[5,42.45,4.9,49.1]],['L',[11.2,49.1]],['C',[11.1,43.85,12.9,39.9]],['C',[14.65,35.9,18.25,33.65]],['C',[21.85,31.45,27.1,31.4]],['C',[31.35,31.4,34.75,32.8]],['C',[38.25,34.15,40.3,37.1]],['C',[42.35,40,42.4,44.6]],['C',[42.3,49,40.15,51.85]],['C',[38,54.65,34.75,56.05]],['C',[31.5,57.35,28.15,57.3]],['L',[22.9,57.3]],['L',[22.9,62.6]],['L',[28.15,62.6]],['C',[32.9,62.6,36.7,64.25]],['C',[40.5,65.9,42.7,69.15]],['C',[44.95,72.5,45,77.4]],['C',[44.95,82.4,42.45,85.85]],['C',[39.9,89.35,35.85,91.1]],['C',[31.8,92.9,27.1,92.9]],['C',[18.55,92.8,13.95,87.8]],['C',[9.4,82.85,9.6,74.4]],['L',[3.3,74.4]],['C',[2.9,81.9,5.85,87.25]],['C',[8.8,92.55,14.35,95.4]],['C',[19.9,98.15,27.2,98.2]],['C',[33.75,98.2,39.2,95.7]],['C',[44.65,93.3,47.95,88.5]],['C',[51.2,83.75,51.3,76.9]],['C',[51.25,69.9,47.5,65.35]],['C',[43.8,60.8,36.9,59.6]],['L',[36.9,59.4]],['C',[42.55,58,45.6,53.85]],['C',[48.65,49.7,48.7,43.9]],['C',[48.6,37.7,45.5,33.75]]];
			__motifs["4"] = [['M',[35.3,35.9]],['L',[35.3,74]],['L',[8.7,74]],['L',[35.1,35.9]],['L',[35.3,35.9]],['M',[35.3,79.3]],['L',[35.3,96.7]],['L',[41.1,96.7]],['L',[41.1,79.3]],['L',[51.6,79.3]],['L',[51.6,74]],['L',[41.1,74]],['L',[41.1,26.7]],['L',[35.4,26.7]],['L',[3.05,73.2]],['L',[3.05,79.3]],['L',[35.3,79.3]]];
			__motifs["5"] = [['M',[47.45,27.6]],['L',[12.5,27.6]],['L',[5.7,63.9]],['L',[11.1,63.9]],['C',[13.7,59.9,17.85,57.75]],['C',[21.95,55.6,26.7,55.6]],['C',[31.95,55.65,35.95,58.05]],['C',[40,60.35,42.25,64.45]],['C',[44.55,68.6,44.6,73.8]],['C',[44.6,79,42.45,83.25]],['C',[40.35,87.6,36.45,90.2]],['C',[32.5,92.85,27.1,92.9]],['C',[22.25,92.9,18.45,90.85]],['C',[14.65,88.85,12.35,85.25]],['C',[10.1,81.55,9.9,76.7]],['L',[3.6,76.7]],['C',[3.8,83.35,6.85,88.2]],['C',[9.8,93,14.95,95.6]],['C',[20.05,98.15,26.6,98.2]],['C',[33.35,98.15,38.8,95.1]],['C',[44.35,92.05,47.55,86.75]],['C',[50.8,81.4,50.9,74.5]],['C',[50.85,67.4,48,61.95]],['C',[45.1,56.5,39.9,53.45]],['C',[34.6,50.3,27.4,50.25]],['C',[23.25,50.3,19.3,51.95]],['C',[15.35,53.7,12.6,56.75]],['L',[12.4,56.55]],['L',[16.9,33.4]],['L',[47.45,33.4]],['L',[47.45,27.6]]];
			__motifs["6"] = [['M',[38.15,58.95]],['C',[41.9,61.4,43.9,65.6]],['C',[45.9,69.75,45.9,74.9]],['C',[45.85,79.8,43.75,83.85]],['C',[41.65,87.95,37.9,90.4]],['C',[34.15,92.85,29.1,92.9]],['C',[23.05,92.85,19.15,90.45]],['C',[15.3,88,13.45,83.95]],['C',[11.6,79.9,11.6,74.9]],['C',[11.6,69.7,13.65,65.55]],['C',[15.7,61.35,19.65,58.9]],['C',[23.5,56.45,29,56.4]],['C',[34.4,56.45,38.15,58.95]],['M',[43.8,30.7]],['C',[38.3,26.1,29,26.1]],['C',[22.15,26.2,17.65,28.95]],['C',[13.05,31.65,10.3,36]],['C',[7.55,40.3,6.2,45.15]],['C',[4.85,49.95,4.4,54.15]],['C',[3.95,58.4,4,61]],['C',[4,74.6,6.6,82.8]],['C',[9.2,91,14.6,94.65]],['C',[20,98.25,28.5,98.2]],['C',[35.45,98.15,40.75,95.1]],['C',[46.1,92,49.1,86.7]],['C',[52.15,81.35,52.2,74.5]],['C',[52.15,67.6,49.3,62.35]],['C',[46.5,57.1,41.3,54.1]],['C',[36.15,51.15,29.1,51.1]],['C',[23.1,51.2,18.05,54.3]],['C',[13.1,57.45,10.5,62.7]],['L',[10.3,62.7]],['C',[10.25,57.85,11.05,52.45]],['C',[11.8,47.1,13.85,42.3]],['C',[15.9,37.5,19.75,34.5]],['C',[23.55,31.5,29.6,31.4]],['C',[35.75,31.5,39.5,35.05]],['C',[43.3,38.55,44.2,44.4]],['L',[50.5,44.4]],['C',[49.3,35.25,43.8,30.7]]];
			__motifs["7"] = [['M',[50.1,33.4]],['L',[50.1,27.6]],['L',[5.1,27.6]],['L',[5.1,33.4]],['L',[43.75,33.4]],['C',[34.15,44.35,28.1,54.35]],['C',[22,64.4,18.9,74.7]],['C',[15.75,84.95,15,96.7]],['L',[21.8,96.7]],['C',[22.45,84.5,25.65,74.35]],['C',[28.8,64.25,33.25,56.2]],['C',[37.7,48.25,42.2,42.55]],['C',[46.75,36.85,50.1,33.4]]];
			__motifs["8"] = [['M',[36.55,63.5]],['C',[40.65,65.2,43.05,68.6]],['C',[45.5,72.05,45.6,77.1]],['C',[45.55,82.45,43.15,85.95]],['C',[40.75,89.45,36.75,91.2]],['C',[32.75,92.9,27.8,92.9]],['C',[22.85,92.9,18.85,91.15]],['C',[14.8,89.4,12.45,85.85]],['C',[10.05,82.35,10,77.1]],['C',[10.05,71.95,12.5,68.55]],['C',[14.9,65.1,18.9,63.45]],['C',[22.95,61.8,27.8,61.9]],['C',[32.55,61.8,36.55,63.5]],['M',[42.7,43.6]],['C',[42.65,48.1,40.55,51]],['C',[38.5,53.95,35.1,55.35]],['C',[31.7,56.7,27.8,56.6]],['C',[24,56.7,20.6,55.4]],['C',[17.25,54.1,15.05,51.2]],['C',[12.9,48.25,12.8,43.6]],['C',[12.85,39.6,15,36.9]],['C',[17.1,34.15,20.5,32.8]],['C',[23.9,31.4,27.8,31.4]],['C',[32.05,31.4,35.4,32.8]],['C',[38.75,34.15,40.7,36.9]],['C',[42.7,39.6,42.7,43.6]],['M',[45.8,33.7]],['C',[42.7,29.85,37.85,27.95]],['C',[33,26.1,27.7,26.1]],['C',[22.45,26.1,17.65,27.95]],['C',[12.8,29.85,9.7,33.7]],['C',[6.6,37.6,6.5,43.6]],['C',[6.55,49.4,9.45,53.35]],['C',[12.4,57.3,17.9,59]],['L',[17.9,59.2]],['C',[11.4,60.5,7.65,65.35]],['C',[3.9,70.15,3.7,77.1]],['C',[3.75,84.15,7.05,88.85]],['C',[10.3,93.55,15.7,95.85]],['C',[21.2,98.2,27.8,98.2]],['C',[34.4,98.2,39.9,95.85]],['C',[45.3,93.55,48.6,88.85]],['C',[51.8,84.15,51.9,77.1]],['C',[51.85,70,48.15,65.3]],['C',[44.4,60.6,37.6,59.2]],['L',[37.6,59]],['C',[42.95,57.4,45.95,53.35]],['C',[48.95,49.35,49,43.6]],['C',[48.9,37.6,45.8,33.7]]];
			__motifs["9"] = [['M',[44,49.4]],['C',[44,54.6,41.95,58.75]],['C',[39.9,62.95,36,65.4]],['C',[32.15,67.85,26.6,67.9]],['C',[21.25,67.85,17.5,65.35]],['C',[13.7,62.9,11.7,58.7]],['C',[9.7,54.55,9.7,49.4]],['C',[9.75,44.5,11.85,40.45]],['C',[13.95,36.35,17.7,33.9]],['C',[21.5,31.45,26.5,31.4]],['C',[32.55,31.45,36.45,33.85]],['C',[40.35,36.3,42.2,40.35]],['C',[44,44.4,44,49.4]],['M',[41,29.65]],['C',[35.6,26.05,27.1,26.1]],['C',[20.15,26.15,14.85,29.2]],['C',[9.5,32.3,6.5,37.6]],['C',[3.45,42.95,3.4,49.85]],['C',[3.45,56.7,6.3,61.95]],['C',[9.15,67.2,14.3,70.2]],['C',[19.5,73.15,26.5,73.2]],['C',[32.5,73.1,37.55,70]],['C',[42.55,66.85,45.1,61.6]],['L',[45.3,61.6]],['C',[45.35,66.5,44.6,71.85]],['C',[43.8,77.2,41.75,82]],['C',[39.7,86.8,35.9,89.8]],['C',[32.1,92.8,26.05,92.9]],['C',[19.85,92.8,16.05,89.3]],['C',[12.25,85.75,11.4,79.9]],['L',[5.1,79.9]],['C',[6.25,89.05,11.75,93.6]],['C',[17.3,98.2,26.6,98.2]],['C',[33.45,98.1,38,95.4]],['C',[42.55,92.65,45.3,88.3]],['C',[48.05,84,49.4,79.15]],['C',[50.8,74.35,51.2,70.15]],['C',[51.65,65.9,51.6,63.3]],['C',[51.6,49.75,49,41.5]],['C',[46.45,33.3,41,29.65]]];
		}

		static private function initializeMotifsPunctuation():void {
			__motifs[" "] = [];
			__motifs["!"] = [['M',[16.3,86.1]],['L',[7.9,86.1]],['L',[7.9,96.7]],['L',[16.3,96.7]],['L',[16.3,86.1]],['M',[15.5,25.3]],['L',[8.7,25.3]],['L',[8.7,46.6]],['L',[10.2,78.95]],['L',[13.95,78.95]],['L',[15.5,46.6]],['L',[15.5,25.3]]];
			__motifs["\""] = [['M',[22,25.3]],['L',[22,49.65]],['L',[28.3,49.65]],['L',[28.3,25.3]],['L',[22,25.3]],['M',[8.7,25.3]],['L',[8.7,49.65]],['L',[15,49.65]],['L',[15,25.3]],['L',[8.7,25.3]]];
			__motifs["#"] = [['M',[36.4,54.3]],['L',[34.2,69.9]],['L',[20.05,69.9]],['L',[22.25,54.3]],['L',[36.4,54.3]],['M',[21,27.6]],['L',[17.85,49.85]],['L',[6.3,49.85]],['L',[6.3,54.3]],['L',[17.3,54.3]],['L',[15.1,69.9]],['L',[3.45,69.9]],['L',[3.45,74.4]],['L',[14.45,74.4]],['L',[11.4,96.7]],['L',[16.35,96.7]],['L',[19.5,74.4]],['L',[33.6,74.4]],['L',[30.45,96.7]],['L',[35.5,96.7]],['L',[38.55,74.4]],['L',[49.65,74.4]],['L',[49.65,69.9]],['L',[39.15,69.9]],['L',[41.35,54.3]],['L',[52.5,54.3]],['L',[52.5,49.85]],['L',[42,49.85]],['L',[45.05,27.6]],['L',[40.1,27.6]],['L',[36.95,49.85]],['L',[22.9,49.85]],['L',[26,27.6]],['L',[21,27.6]]];
			__motifs["$"] = [['M',[37.4,66.5]],['C',[41.25,68.05,43.75,70.8]],['C',[46.3,73.6,46.4,78.3]],['C',[46.35,83.45,43.95,86.7]],['C',[41.55,89.9,37.75,91.45]],['C',[33.95,92.95,29.6,92.9]],['L',[29.6,64.1]],['C',[33.6,65,37.4,66.5]],['M',[13.05,35.45]],['C',[15,32.2,18.3,30.65]],['C',[21.65,29.1,25.7,29.1]],['L',[25.7,57]],['C',[21.9,56.15,18.55,54.9]],['C',[15.2,53.65,13.15,51.1]],['C',[11.05,48.6,11,44]],['C',[11.05,38.8,13.05,35.45]],['M',[50.8,45.55]],['C',[50.85,38.95,48,34.05]],['C',[45.1,29.2,40.3,26.55]],['C',[35.45,23.85,29.6,23.8]],['L',[29.6,16]],['L',[25.7,16]],['L',[25.7,23.8]],['C',[19.8,23.85,15.1,26.2]],['C',[10.35,28.55,7.55,32.95]],['C',[4.75,37.3,4.7,43.35]],['C',[4.8,50.2,7.6,54.15]],['C',[10.5,58.1,15.25,60.15]],['C',[19.95,62.15,25.7,63.3]],['L',[25.7,92.9]],['C',[17.75,92,13.55,87.3]],['C',[9.3,82.55,9.2,73.9]],['L',[2.9,73.9]],['C',[3.2,85.25,8.65,91.15]],['C',[14.05,97.05,25.7,98.1]],['L',[25.7,106.7]],['L',[29.6,106.7]],['L',[29.6,98.2]],['C',[35.55,98.25,40.75,95.95]],['C',[46,93.7,49.3,89.25]],['C',[52.6,84.75,52.7,78.2]],['C',[52.6,71.25,49.2,67.25]],['C',[45.9,63.2,40.65,61.1]],['C',[35.4,59,29.6,57.95]],['L',[29.6,29.1]],['C',[36.25,29.2,40.3,33.55]],['C',[44.3,37.9,44.5,45.55]],['L',[50.8,45.55]]];
			__motifs["%"] = [['M',[13.1,38.5]],['C',[14,35.2,16.3,32.95]],['C',[18.65,30.7,22.8,30.6]],['C',[26.95,30.7,29.3,32.95]],['C',[31.6,35.2,32.5,38.5]],['C',[33.45,41.8,33.4,45.1]],['C',[33.45,48.3,32.5,51.6]],['C',[31.6,54.85,29.3,57.1]],['C',[26.95,59.3,22.8,59.4]],['C',[18.65,59.3,16.3,57.1]],['C',[14,54.85,13.1,51.6]],['C',[12.15,48.3,12.2,45.1]],['C',[12.15,41.8,13.1,38.5]],['M',[8.5,35.3]],['C',[6.9,39.55,6.9,45]],['C',[6.9,50.4,8.5,54.65]],['C',[10.15,58.9,13.65,61.35]],['C',[17.2,63.85,22.8,63.9]],['C',[28.4,63.85,31.95,61.35]],['C',[35.45,58.9,37.1,54.65]],['C',[38.7,50.4,38.7,45]],['C',[38.7,39.55,37.1,35.3]],['C',[35.45,31.1,31.95,28.65]],['C',[28.4,26.15,22.8,26.1]],['C',[17.2,26.15,13.65,28.65]],['C',[10.15,31.1,8.5,35.3]],['M',[64.3,24.2]],['L',[19,100.05]],['L',[23.8,100.05]],['L',[69,24.2]],['L',[64.3,24.2]],['M',[76.4,72.8]],['C',[77.35,76.15,77.3,79.4]],['C',[77.35,82.65,76.4,85.9]],['C',[75.5,89.2,73.2,91.45]],['C',[70.85,93.6,66.7,93.7]],['C',[62.55,93.6,60.2,91.45]],['C',[57.9,89.2,57,85.9]],['C',[56.05,82.65,56.1,79.4]],['C',[56.05,76.15,57,72.8]],['C',[57.9,69.5,60.2,67.25]],['C',[62.55,65,66.7,64.9]],['C',[70.85,65,73.2,67.25]],['C',[75.5,69.5,76.4,72.8]],['M',[82.6,79.3]],['C',[82.6,73.9,81,69.65]],['C',[79.35,65.4,75.85,62.95]],['C',[72.3,60.45,66.7,60.4]],['C',[61.1,60.45,57.55,62.95]],['C',[54.05,65.4,52.4,69.65]],['C',[50.8,73.9,50.8,79.3]],['C',[50.8,84.75,52.4,89]],['C',[54.05,93.25,57.55,95.65]],['C',[61.1,98.15,66.7,98.2]],['C',[72.3,98.15,75.85,95.65]],['C',[79.35,93.25,81,89]],['C',[82.6,84.75,82.6,79.3]]];
			__motifs["&"] = [['M',[17.95,65.45]],['C',[21.35,62.95,24.8,61.1]],['L',[42.6,82.7]],['C',[39.6,87.1,35.3,89.95]],['C',[31.05,92.8,25.7,92.9]],['C',[21.6,92.9,18.05,91.15]],['C',[14.6,89.35,12.4,86.2]],['C',[10.25,83.05,10.2,78.85]],['C',[10.3,74.55,12.45,71.2]],['C',[14.65,67.95,17.95,65.45]],['M',[28.4,30.65]],['C',[32.4,30.65,35.1,33.05]],['C',[37.8,35.35,37.9,39.8]],['C',[37.85,43.3,36.15,45.9]],['C',[34.45,48.6,32,50.65]],['C',[29.45,52.7,26.9,54.2]],['C',[25.3,52.3,23.45,49.9]],['C',[21.6,47.55,20.25,44.95]],['C',[18.95,42.35,18.9,39.8]],['C',[19,35.35,21.7,33.05]],['C',[24.35,30.65,28.4,30.65]],['M',[44.2,39.8]],['C',[44.15,35.45,42.05,32.2]],['C',[39.9,28.95,36.4,27.15]],['C',[32.8,25.35,28.4,25.3]],['C',[23.95,25.35,20.4,27.15]],['C',[16.9,28.95,14.75,32.2]],['C',[12.65,35.45,12.6,39.8]],['C',[12.65,43.25,14,46.2]],['C',[15.4,49.2,17.4,51.85]],['C',[19.4,54.45,21.4,57]],['C',[17.3,59.15,13.35,62.15]],['C',[9.35,65.15,6.7,69.1]],['C',[4,73.1,3.9,78.2]],['C',[3.95,84.65,6.8,89.15]],['C',[9.55,93.6,14.45,95.85]],['C',[19.3,98.2,25.5,98.2]],['C',[31.85,98.1,37.2,95.25]],['C',[42.6,92.35,46.5,87.4]],['L',[54.1,96.7]],['L',[62,96.7]],['L',[50,82.2]],['C',[52.45,77.5,53.3,72.85]],['C',[54.25,68.25,54.2,65.1]],['L',[47.9,65.1]],['C',[47.95,69.05,47.5,71.8]],['C',[47.05,74.6,45.8,77.1]],['L',[30.2,58.3]],['C',[33.8,56.1,36.95,53.5]],['C',[40.15,50.9,42.15,47.6]],['C',[44.15,44.25,44.2,39.8]]];
			__motifs["'"] = [['M',[10.8,25.3]],['L',[10.8,49.65]],['L',[17.1,49.65]],['L',[17.1,25.3]],['L',[10.8,25.3]]];
			__motifs["("] = [['M',[24.15,23.8]],['L',[19.2,23.8]],['C',[12.6,33.95,8.9,45.65]],['C',[5.15,57.3,5.1,70.1]],['C',[5.1,78.75,6.75,86.4]],['C',[8.4,94.05,11.55,101.3]],['C',[14.7,108.45,19.2,115.8]],['L',[24.15,115.8]],['C',[20.35,109.55,17.5,102.25]],['C',[14.6,95,13,87.35]],['C',[11.4,79.7,11.4,72.4]],['C',[11.35,59.15,14.45,46.85]],['C',[17.55,34.5,24.15,23.8]]];
			__motifs[")"] = [['M',[4.9,23.8]],['L',[-0.1,23.8]],['C',[3.7,30.05,6.6,37.35]],['C',[9.45,44.6,11.1,52.25]],['C',[12.7,59.9,12.7,67.2]],['C',[12.75,80.45,9.6,92.75]],['C',[6.55,105.1,-0.1,115.8]],['L',[4.9,115.8]],['C',[11.45,105.65,15.2,93.95]],['C',[18.95,82.3,19,69.5]],['C',[19,60.85,17.35,53.2]],['C',[15.65,45.55,12.5,38.3]],['C',[9.4,31.1,4.9,23.8]]];
			__motifs["*"] = [['M',[19.5,25.3]],['L',[15.6,25.3]],['L',[15.6,37.6]],['L',[4.1,33.5]],['L',[2.7,37.25]],['L',[14.15,41.1]],['L',[6.9,50.9]],['L',[10.1,53.2]],['L',[17.4,43.2]],['L',[24.65,53.2]],['L',[27.9,50.9]],['L',[20.65,41.1]],['L',[32.45,37.25]],['L',[30.95,33.5]],['L',[19.5,37.6]],['L',[19.5,25.3]]];
			__motifs["+"] = [['M',[27.4,46.35]],['L',[27.4,68.85]],['L',[4.9,68.85]],['L',[4.9,74.2]],['L',[27.4,74.2]],['L',[27.4,96.7]],['L',[32.7,96.7]],['L',[32.7,74.2]],['L',[55.2,74.2]],['L',[55.2,68.85]],['L',[32.7,68.85]],['L',[32.7,46.35]],['L',[27.4,46.35]]];
			__motifs[","] = [['M',[9.7,96.7]],['L',[13.9,96.7]],['C',[14,98.4,13.55,100.3]],['C',[13.1,102.25,12,103.9]],['C',[11,105.45,9.35,106.1]],['L',[9.35,110.4]],['C',[12.3,109.5,14.25,107.4]],['C',[16.15,105.3,17.15,102.5]],['C',[18.05,99.75,18.1,96.8]],['L',[18.1,86.1]],['L',[9.7,86.1]],['L',[9.7,96.7]]];
			__motifs["-"] = [['M',[31,66.3]],['L',[6,66.3]],['L',[6,72.1]],['L',[31,72.1]],['L',[31,66.3]]];
			__motifs["."] = [['M',[18.1,86.1]],['L',[9.7,86.1]],['L',[9.7,96.7]],['L',[18.1,96.7]],['L',[18.1,86.1]]];
			__motifs["/"] = [['M',[29.5,23.8]],['L',[-1.3,98.2]],['L',[4.1,98.2]],['L',[34.55,23.8]],['L',[29.5,23.8]]];
			__motifs[":"] = [['M',[18.1,86.1]],['L',[9.7,86.1]],['L',[9.7,96.7]],['L',[18.1,96.7]],['L',[18.1,86.1]],['M',[9.7,46.7]],['L',[9.7,57.3]],['L',[18.1,57.3]],['L',[18.1,46.7]],['L',[9.7,46.7]]];
			__motifs[";"] = [['M',[9.7,96.7]],['L',[13.9,96.7]],['C',[14,98.4,13.55,100.3]],['C',[13.1,102.25,12,103.9]],['C',[11,105.45,9.35,106.1]],['L',[9.35,110.4]],['C',[12.3,109.5,14.25,107.4]],['C',[16.15,105.3,17.15,102.5]],['C',[18.05,99.75,18.1,96.8]],['L',[18.1,86.1]],['L',[9.7,86.1]],['L',[9.7,96.7]],['M',[9.7,46.7]],['L',[9.7,57.3]],['L',[18.1,57.3]],['L',[18.1,46.7]],['L',[9.7,46.7]]];
			__motifs["<"] = [['M',[4.6,74.15]],['L',[55.35,97.55]],['L',[55.35,92]],['L',[10.8,71.4]],['L',[55.35,50.85]],['L',[55.35,45.35]],['L',[4.6,68.7]],['L',[4.6,74.15]]];
			__motifs["="] = [['M',[4.9,83.9]],['L',[55.2,83.9]],['L',[55.2,78.6]],['L',[4.9,78.6]],['L',[4.9,83.9]],['M',[4.9,64.25]],['L',[55.2,64.25]],['L',[55.2,58.9]],['L',[4.9,58.9]],['L',[4.9,64.25]]];
			__motifs[">"] = [['M',[4.6,97.55]],['L',[55.35,74.15]],['L',[55.35,68.7]],['L',[4.6,45.35]],['L',[4.6,50.85]],['L',[49.15,71.4]],['L',[4.6,92]],['L',[4.6,97.55]]];
			__motifs["?"] = [['M',[31.5,96.7]],['L',[31.5,86.1]],['L',[23.1,86.1]],['L',[23.1,96.7]],['L',[31.5,96.7]],['M',[45.6,32.35]],['C',[42.85,28.25,38.3,26.05]],['C',[33.75,23.85,28.15,23.8]],['C',[20.85,23.85,15.8,26.75]],['C',[10.8,29.65,8.1,34.95]],['C',[5.45,40.15,5.4,47.35]],['L',[11.7,47.35]],['C',[11.6,42.1,13.4,38]],['C',[15.15,33.9,18.75,31.55]],['C',[22.35,29.15,27.8,29.1]],['C',[31.75,29.1,34.95,30.85]],['C',[38.2,32.55,40.15,35.55]],['C',[42.05,38.6,42.1,42.6]],['C',[42.05,46.5,40.25,49.7]],['C',[38.45,52.9,35.6,55.5]],['C',[32.45,58.35,30.2,60.7]],['C',[28,63.05,26.6,65.5]],['C',[25.2,67.9,24.6,71.05]],['C',[24,74.25,24.1,78.85]],['L',[30.4,78.85]],['C',[30.5,74.35,30.8,71.8]],['C',[31.1,69.3,32,67.7]],['C',[32.85,66.05,34.7,64.25]],['C',[36.5,62.4,39.7,59.3]],['C',[43.6,55.8,45.95,51.8]],['C',[48.35,47.75,48.4,42.3]],['C',[48.35,36.5,45.6,32.35]]];
			__motifs["@"] = [['M',[46.4,47.1]],['C',[48.2,48.4,49.35,50.5]],['C',[50.5,52.6,50.55,55]],['C',[50.5,58.35,49.2,62.35]],['C',[47.95,66.4,45.7,70.05]],['C',[43.45,73.7,40.45,76.05]],['C',[37.4,78.45,33.9,78.5]],['C',[30.2,78.45,27.95,75.9]],['C',[25.65,73.35,25.6,68.75]],['C',[25.6,65.2,26.8,61.25]],['C',[28.05,57.25,30.25,53.75]],['C',[32.5,50.2,35.65,48]],['C',[38.75,45.75,42.65,45.7]],['C',[44.6,45.75,46.4,47.1]],['M',[53.6,48.8]],['C',[51.9,44.35,49.1,42.35]],['C',[46.4,40.35,43,40.4]],['C',[37.65,40.45,33.3,43]],['C',[28.95,45.5,25.85,49.7]],['C',[22.7,53.9,21,58.95]],['C',[19.3,64.1,19.3,69.3]],['C',[19.3,73.3,20.9,76.6]],['C',[22.45,79.85,25.45,81.8]],['C',[28.35,83.75,32.5,83.8]],['C',[36.4,83.7,39.65,81.7]],['C',[42.9,79.7,45.2,77.2]],['L',[45.4,77.2]],['C',[45.8,80.5,47.65,82.2]],['C',[49.5,83.9,52.1,83.9]],['C',[57.8,83.8,63.1,79.95]],['C',[68.35,76.1,71.8,69.6]],['C',[75.15,63.05,75.3,54.9]],['C',[75.2,45.65,70.8,38.65]],['C',[66.4,31.65,58.8,27.75]],['C',[51.15,23.85,41.4,23.8]],['C',[31.1,23.9,22.8,28.75]],['C',[14.55,33.55,9.65,41.85]],['C',[4.8,50.2,4.7,60.7]],['C',[4.8,71.35,9.5,79.8]],['C',[14.3,88.25,22.65,93.2]],['C',[30.95,98.1,41.8,98.2]],['C',[48.15,98.15,54.05,96.05]],['C',[59.95,93.9,64.8,89.9]],['C',[69.65,85.95,72.7,80.4]],['L',[67.6,80.4]],['C',[64.65,84.6,60.5,87.55]],['C',[56.4,90.55,51.55,92.1]],['C',[46.8,93.7,41.8,93.7]],['C',[32.6,93.6,25.5,89.4]],['C',[18.3,85.2,14.2,77.9]],['C',[10.1,70.65,10,61.4]],['C',[10.05,52.1,14.05,44.65]],['C',[18,37.2,25.1,32.8]],['C',[32.2,28.4,41.6,28.3]],['C',[49.4,28.35,55.8,31.45]],['C',[62.2,34.6,66.05,40.45]],['C',[69.85,46.3,69.95,54.6]],['C',[69.95,58.85,68.6,63.2]],['C',[67.25,67.55,64.9,71.2]],['C',[62.5,74.85,59.5,77.1]],['C',[56.5,79.35,53.15,79.4]],['C',[50.75,79.3,50.75,76.9]],['C',[50.7,74.45,51.8,71.1]],['L',[61.4,42.3]],['L',[56.1,42.3]],['L',[53.6,48.8]]];
			__motifs["["] = [['M',[23.75,29.1]],['L',[23.75,23.8]],['L',[7.6,23.8]],['L',[7.6,115.8]],['L',[23.75,115.8]],['L',[23.75,110.45]],['L',[13.9,110.45]],['L',[13.9,29.1]],['L',[23.75,29.1]]];
			__motifs["\\"] = [['M',[34.55,98.2]],['L',[3.75,23.8]],['L',[-1.3,23.8]],['L',[29.15,98.2]],['L',[34.55,98.2]]];
			__motifs["]"] = [['M',[0.4,29.1]],['L',[10.2,29.1]],['L',[10.2,110.45]],['L',[0.4,110.45]],['L',[0.4,115.8]],['L',[16.5,115.8]],['L',[16.5,23.8]],['L',[0.4,23.8]],['L',[0.4,29.1]]];
			__motifs["^"] = [['M',[27.4,27.6]],['L',[4.4,72.9]],['L',[10.2,72.9]],['L',[29.9,33.9]],['L',[49.9,72.9]],['L',[55.6,72.9]],['L',[32.6,27.6]],['L',[27.4,27.6]]];
			__motifs["_"] = [['M',[50,104.2]],['L',[0,104.2]],['L',[0,109.2]],['L',[50,109.2]],['L',[50,104.2]]];
			__motifs["`"] = [['M',[15.2,37.9]],['L',[4.7,23.8]],['L',[-3.1,23.8]],['L',[10.05,37.9]],['L',[15.2,37.9]]];
		}

		static private function initializeWidthsUppercase():void {
			__widths["A"] = 63;
			__widths["B"] = 67;
			__widths["C"] = 70;
			__widths["D"] = 69;
			__widths["E"] = 59;
			__widths["F"] = 54;
			__widths["G"] = 74;
			__widths["H"] = 70;
			__widths["I"] = 22;
			__widths["J"] = 50;
			__widths["K"] = 65;
			__widths["L"] = 54;
			__widths["M"] = 83;
			__widths["N"] = 70;
			__widths["O"] = 74;
			__widths["P"] = 63;
			__widths["Q"] = 74;
			__widths["R"] = 67;
			__widths["S"] = 63;
			__widths["T"] = 56;
			__widths["U"] = 69;
			__widths["V"] = 59;
			__widths["W"] = 91;
			__widths["X"] = 57;
			__widths["Y"] = 61;
			__widths["Z"] = 57;
		}

		static private function initializeWidthsLowercase():void {
			__widths["a"] = 52;
			__widths["b"] = 57;
			__widths["c"] = 52;
			__widths["d"] = 57;
			__widths["e"] = 52;
			__widths["f"] = 26;
			__widths["g"] = 56;
			__widths["h"] = 54;
			__widths["i"] = 19;
			__widths["j"] = 19;
			__widths["k"] = 50;
			__widths["l"] = 19;
			__widths["m"] = 83;
			__widths["n"] = 54;
			__widths["o"] = 56;
			__widths["p"] = 57;
			__widths["q"] = 57;
			__widths["r"] = 32;
			__widths["s"] = 48;
			__widths["t"] = 30;
			__widths["u"] = 54;
			__widths["v"] = 46;
			__widths["w"] = 74;
			__widths["x"] = 48;
			__widths["y"] = 46;
			__widths["z"] = 46;
		}

		static private function initializeWidthsNumbers():void {
			__widths["0"] = 56;
			__widths["1"] = 56;
			__widths["2"] = 56;
			__widths["3"] = 56;
			__widths["4"] = 56;
			__widths["5"] = 56;
			__widths["6"] = 56;
			__widths["7"] = 56;
			__widths["8"] = 56;
			__widths["9"] = 56;
		}

		static private function initializeWidthsPunctuation():void {
			__widths[" "] = 28;
			__widths["!"] = 24;
			__widths["\""] = 37;
			__widths["#"] = 56;
			__widths["$"] = 56;
			__widths["%"] = 89;
			__widths["&"] = 61;
			__widths["'"] = 28;
			__widths["("] = 24;
			__widths[")"] = 24;
			__widths["*"] = 35;
			__widths["+"] = 60;
			__widths[","] = 28;
			__widths["-"] = 37;
			__widths["."] = 28;
			__widths["/"] = 33;
			__widths[":"] = 28;
			__widths[";"] = 28;
			__widths["<"] = 60;
			__widths["="] = 60;
			__widths[">"] = 60;
			__widths["?"] = 54;
			__widths["@"] = 80;
			__widths["["] = 24;
			__widths["\\"] = 33;
			__widths["]"] = 24;
			__widths["^"] = 60;
			__widths["_"] = 50;
			__widths["`"] = 19;
		}

	}

}
